package com.ypsx.yppos.viewmodel.request

import androidx.lifecycle.MutableLiveData
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.ext.launch
import com.ypsx.base.ext.request
import com.ypsx.base.util.LogUtils
import com.ypsx.yppos.utils.toast
import com.ypsx.yppos.http.data.bean.PosMachineResponse
import com.ypsx.yppos.http.data.request.ApplyPosMachineRequest
import com.ypsx.yppos.http.repository.request.HttpRequestCoroutine
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.dXLog
import com.ypsx.yppos.utils.eXLog

class RequestRegisterViewModel : BaseViewModel() {
    var posDetails = MutableLiveData<PosMachineResponse>()



    fun applyPos(applyPosMachineRequest: ApplyPosMachineRequest) {
        request({ HttpRequestCoroutine.applyPos(applyPosMachineRequest) }, {
            posDetails.postValue(it)
        }, {
            val errorMsg = it.errorMsg
            errorMsg.toast()
            LogUtils.debugInfo(errorMsg)
        },isShowDialog = true)
    }


    fun getById(id: String) {
        request({ HttpRequestCoroutine.getById(id) }, {
            posDetails.postValue(it)
        },{
          it.errorMsg.eXLog()
        },isShowDialog = true)
    }

    fun savePosConfig(posMachineResponse: PosMachineResponse) {
        launch({ PosConfigRepository.getInstance().savePosDetail(posMachineResponse) }, {
            LogUtils.debugInfo("保存数据库PosConfig成功")
        }, {
            LogUtils.debugInfo("保存数据库PosConfig失败")
        })
    }
}