package com.ypsx.yppos.viewmodel.state

import android.view.View
import androidx.databinding.ObservableInt
import com.ypsx.base.base.appContext
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.base.network.NetworkUtil
import com.ypsx.base.util.AppUtils
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.CacheUtil

class LoginViewModel : BaseViewModel() {
    val version = "版本号：V${AppUtils.getAppVersionName()}"
    var posCode = StringObservableField()
    var storeName = StringObservableField()
    var localIp = StringObservableField()
    var enabledStatus = BooleanObservableField(false)

    var posId = StringObservableField()


    //用户名
    var account = StringObservableField()

    //密码(登录注册界面)
    var password = StringObservableField()

    // 输入框密码是否是隐藏的，默认为true
    var isHideFirst = BooleanObservableField(true)


    init {
        val posConfig = PosConfigRepository.getInstance().loadConfig()
        posId.set(posConfig?.id)
        posCode.set("机号：${posConfig?.code}")
        storeName.set("门店：${posConfig?.storeName}")
        localIp.set("本地：${NetworkUtil.getIPAddress(appContext)}")
        val loginResponse = CacheUtil.getLoginResponse()
        if (loginResponse != null) {
            account.set(loginResponse.loginUser.username)
        }
    }


}