package com.ypsx.yppos.viewmodel.state

import android.view.View
import androidx.databinding.ObservableInt
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.DoubleObservableField
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.yppos.http.data.bean.LoginUser
import com.ypsx.yppos.room.entity.PosBuy
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.CacheUtil
import com.ypsx.yppos.utils.DateUtil
import java.util.*

class MainViewModel : BaseViewModel() {

    var storeName = StringObservableField()

    var tipsShow = BooleanObservableField(true)

    var orderNo = StringObservableField()

    var shopId = StringObservableField()
    var memberId = StringObservableField("")

    var code = ""

    var payAmount = StringObservableField("0.00")
    var discount = StringObservableField("0.00")

    var discountMoney = StringObservableField("0.00") //满减促销
    var discountTime = StringObservableField("0.00")//分时促销
    var discountSpecial = StringObservableField("0.00")//特价促销

    var recyclerShow = BooleanObservableField(false)

    var amount = DoubleObservableField(0.00)


    init {
        val loadConfig = PosConfigRepository.getInstance().loadConfig()
        storeName.set(loadConfig?.storeName)

        code = loadConfig?.code!!
        val orderDate = DateUtil.getOrderDate()
        val random = getRandom()

        orderNo.set("$code$orderDate$random")
        shopId.set(loadConfig?.storeId)
//        val loginUser: LoginUser = CacheUtil.getLoginResponse()!!.loginUser
//        val buyID = UUID.randomUUID().toString().replace("-", "")
//        val createTime = DateUtil.getTodayDateTime()

    }

    var tipsVisible = object : ObservableInt(tipsShow) {
        override fun get(): Int {
            return if (tipsShow.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    var recyclerVisible = object : ObservableInt(recyclerShow) {
        override fun get(): Int {
            return if (recyclerShow.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    private fun getRandom(): Int {
        val max = 9
        val min = 0
        return (Math.random() * (max - min) + min).toInt()
    }

    fun resetOrderNo() {
        val orderDate = DateUtil.getOrderDate()
        val random = getRandom()
        orderNo.set("$code$orderDate$random")
    }

    fun resetAmount() {
        payAmount.set("0.00")
        discount.set("0.00")

        discountMoney.set("0.00") //满减促销
        discountTime.set("0.00")//分时促销
        discountSpecial.set("0.00")//特价促销


        amount.set(0.00)
    }

}