package com.ypsx.yppos.viewmodel.state

import android.view.View
import androidx.databinding.ObservableInt
import androidx.lifecycle.viewModelScope
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.yppos.http.data.entity.PosPayMethod
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.dXLog
import kotlinx.coroutines.launch

class OrderPayAmountViewModel : BaseViewModel() {

    var orderNo = StringObservableField()

    var payAmount = StringObservableField()

    var scanOffline = BooleanObservableField(false)

    var scanCardPay = BooleanObservableField(false)

    var offlineVisible = object : ObservableInt(scanOffline) {
        override fun get(): Int {
            return if (scanOffline.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    var cardPayVisible = object : ObservableInt(scanCardPay) {
        override fun get(): Int {
            return if (scanCardPay.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    init {
        viewModelScope.launch {
            val posConfig = PosConfigRepository.getInstance().loadConfig()
            val payMethods = posConfig?.payMethods
//            payMethods.toString().dXLog()
            if (!payMethods.isNullOrEmpty()) {
                val payMethod:List<String> = payMethods.split(",")
                for (str in payMethod) {
                    if (str == PosPayMethod.CCB_BAR_PAY.name) {
                        scanOffline.set(true)
                    }
                    if (str == PosPayMethod.CARDPAY.name) {
                        scanCardPay.set(true)
                    }
                }
            }
        }

    }


}