package com.ypsx.yppos.http

import android.os.Build
import com.ypsx.base.util.AppUtils
import com.ypsx.yppos.http.data.bean.*
import com.ypsx.yppos.http.data.request.*
import com.ypsx.yppos.room.entity.PosProduct
import com.ypsx.yppos.utils.CacheUtil
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface ApiService {

    /**
     * 申请pos机
     */
    @POST("newretail/api/pos/machine/apply")
    suspend fun applyPos(
        @Body applyPos: ApplyPosMachineRequest,
    ): ApiResponse<String>

    /**
     * 根据POS机Id查询POS机详情
     */
    @GET("newretail/api/pos/machine/getById")
    suspend fun getById(@Query("id") id: String): ApiResponse<PosMachineResponse>

    /**
     * pos机用户登录
     */
    @POST("newretail/api/sys/user/pos/login")
    suspend fun posLogin(@Body loginRequest: PosLoginRequest): ApiResponse<LoginResponse>

    /**
     * 注销登录
     */
    @POST("newretail/api/sys/user/pos/logout")
    suspend fun posLogout(): ApiResponse<String?>

    /**
     * 强制退出
     */
    @POST("newretail/api/sys/user/kickoff")
    suspend fun posKickOff(@Body request: KickoffRequest): ApiResponse<String?>

    /**
     * 根据POS机Id查询POS机配置详情
     */
    @GET("newretail/api/pos/config/getByPosId")
    suspend fun getByPosId(@Query("posId") posId: String): ApiResponse<PosConfigResponse>

    /**
     * 增量下载POS门店商品
     */
    @GET("newretail/api/mall/product/store/incrementDownload")
    suspend fun getProductList(
        @Query("storeId") storeId: String,
        @Query("updateTimeBigger") updateTimeBigger: String?=""
    ): ApiResponse<List<PosProduct>>

    /**
     * 取得App最新版本信息
     */
    @GET("newretail/api/sys/app/version/getLastest")
    suspend fun getLastAppVersion(
        @Query("posId") posId: String,
        @Query("type") type: String = "ypsxAndroidPos",
        @Query("osVersion") osVersion: String = Build.VERSION.RELEASE,
        @Query("version") version: Long = AppUtils.getVersionCode()
    ): ApiResponse<AppVersionResponse?>

    /********************************************处理日志*************************************************/


    /**
     * 根据POS机编码查询POS机命令
     */
    @GET("newretail/api/pos/machine/command/getByPosCode")
    suspend fun getCommandByPosCode(@Query("posCode") posCode: String)
            : ApiResponse<List<SimplePosCommandResponse>>



    /**
     * 回复POS机命令，标记已收到命令，准备执行
     */
    @POST("newretail/api/pos/machine/command/reply")
    suspend fun replyCommand(@Body commandIds: ReplyCommandListRequest): ApiResponse<String>

    /**
     * 保存命令处理结果
     *
     */
    @POST("newretail/api/pos/machine/command/saveResult")
    suspend fun saveCommandResult(@Body saveCommandResult: SaveCommandResultRequest): ApiResponse<String>


    /**
     * 获取促销信息
     */
    @POST("newretail/api/mall/promotion/getProductPromotions")
    suspend fun getProductPromotions(@Body request: ProductPromotionRequest): ApiResponse<ProductPromotionsResponse>

    /**
     * 上传订单 返回订单详情
     */
    @POST("newretail/api/mall/order/upload")
    suspend fun uploadOrder(@Body request: List<InsertOrderRequest>): ApiResponse<List<UploadOrderResponse>>

    /**
     * 获得对应的支付订单签名，对于不需要支付签名的支付方式，会直接完成支付
     */
    @POST("newretail/api/payment/unifiedpay/getCashPaySign")
    suspend fun getCashPaySign(@Body request: UnifiedCashPaySignRequest): ApiResponse<String?>

    /**
     * 根据订单标识查询具体订单状态
     */
    @GET("newretail/api/mall/order/getOrderStatusById")
    suspend fun getOrderStatusById(@Query("orderId") orderId: String): ApiResponse<OrderStatusResponse>

    /**
     * 根据订单id获取订单详情
     */
    @GET("newretail/api/mall/order/getDetailsById")
    suspend fun getOrderDetailById(@Query("orderId") orderId: String): ApiResponse<OrderDetailsResponse>

    /**
     * 获取配置
     */
    @GET("newretail/api/sys/options/query")
    suspend fun getOptionsByKeys(@Query("keys") keys: String = CacheUtil.getAliYunKey()): ApiResponse<List<OptionsResponse>>

}