package com.ypsx.yppos.room.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.ypsx.yppos.room.entity.PosBuyPart
import com.ypsx.yppos.room.entity.PosConfig

@Dao
interface PosBuyPartDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(posBuyPart: PosBuyPart)

    @Query("select * from POS_BuyPart Where orderId=:orderNo AND deleted =:deleted")
    fun queryByOrderNo(orderNo:String,deleted:Boolean):List<PosBuyPart>?

}