package com.ypsx.yppos.room.database

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import com.ypsx.yppos.room.dao.*
import com.ypsx.yppos.room.entity.*
const val name:String = "yp_pos.db"
@Database(
    entities = [PosConfig::class, PosProduct::class,
        PosBuy::class, PosBuyPart::class, PosBuyPayment::class], version = 1,exportSchema = false
)
abstract class PosDatabase : RoomDatabase() {

    abstract fun posConfigDao(): PosConfigDao
    abstract fun posProductDao(): PosProductDao

    abstract fun posBuyDao(): PosBuyDao
    abstract fun posBuyPaymentDao(): PosBuyPaymentDao
    abstract fun posBuyPartDao(): PosBuyPartDao


    companion object {
        @Volatile
        private var INSTANCE: PosDatabase? = null


        fun getDatabase(context: Context): PosDatabase {
            val tempInstance = INSTANCE
            if (tempInstance != null) {
                return tempInstance
            }

            synchronized(this) {
                val instance = Room.databaseBuilder(
                    context.applicationContext,
                    PosDatabase::class.java,
                    name
                ).allowMainThreadQueries()
                    .fallbackToDestructiveMigration().build()
                INSTANCE = instance
                return instance
            }
        }

        fun clearAllTables() {
            INSTANCE?.clearAllTables()
        }
    }
}