package com.ypsx.yppos.room.repository

import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.toJson
import com.ypsx.yppos.http.data.bean.OrderDetailsResponse
import com.ypsx.yppos.room.dao.PosBuyDao
import com.ypsx.yppos.room.dao.PosBuyPartDao
import com.ypsx.yppos.room.dao.PosBuyPaymentDao
import com.ypsx.yppos.room.database.PosDatabase
import com.ypsx.yppos.room.entity.PosBuy
import com.ypsx.yppos.room.entity.PosBuyPart
import com.ypsx.yppos.room.entity.PosBuyPayment
import com.ypsx.yppos.utils.dXLog
import com.ypsx.yppos.utils.eXLog

class PosBuyRepository {

    companion object {
        private val instance: PosBuyRepository = PosBuyRepository()

        fun getInstance(): PosBuyRepository {
            return instance
        }
    }

    private fun getPosBuyPartDao(): PosBuyPartDao {
        return PosDatabase.getDatabase(appContext).posBuyPartDao()
    }

    private fun getPosBuyDao(): PosBuyDao {
        return PosDatabase.getDatabase(appContext).posBuyDao()
    }

    private fun getPosBuyPaymentDao(): PosBuyPaymentDao {
        return PosDatabase.getDatabase(appContext).posBuyPaymentDao()
    }

    fun savePosBuy(orderResponse: OrderDetailsResponse, authCode: String) {
        orderResponse.toString().eXLog()
        val isEmpty = orderResponse.activitys?.isEmpty() ?: true
        val activitys = if (isEmpty) "" else orderResponse.activitys.toJson()
        val posBuy = PosBuy(
            id = orderResponse.id,
            orderNo = orderResponse.orderNo,
            posId = orderResponse.posId,
            buyNumber = orderResponse.buyNumber,
            changeAmount = orderResponse.changeAmount,
            payAmount = orderResponse.payAmount,
            discountTotal = orderResponse.discountTotal,
            promotionOnSaleTotal = orderResponse.promotionOnSaleTotal,
            totalAmount = orderResponse.totalAmount,
            roundPrice = orderResponse.roundPrice,
            remark = "",
            einvoiceQrcodeUrl = orderResponse.einvoiceQrcodeUrl,
            status = orderResponse.status,
            storeId = orderResponse.storeId,
            creatorId = orderResponse.creatorId,
            createTime = orderResponse.createTime,
            creatorName = orderResponse.creatorName,
            isUpload = true,
            activitys = activitys,
            type = orderResponse.type,
            mobile = orderResponse.mobile,
            memberId = orderResponse.memberId
        )
        getPosBuyDao().insert(posBuy)
        for (payment in orderResponse.payments) {
            payment.payCode = authCode
            getPosBuyPaymentDao().insert(payment)
        }
        orderResponse.products.toJson().dXLog()
        for (product in orderResponse.products) {
            product.toJson().dXLog()
            val isEmpty1 = product.activitys?.isEmpty() ?: true
            val activity = if (isEmpty1) "" else product.activitys.toJson()
            val activityType = if (isEmpty1) "" else product.activitys?.get(0)?.activityType
            val posBuyPart = PosBuyPart(
                id = product.id,
                orderId = orderResponse.id,
                productId = product.productId,
                quantity = product.paymentProductQuantity,
                barCode = product.barCode,
                tailAmount = product.tailAmount,
                amount = product.amount,
                weightCode = product.weightCode,
                deleted = false,
                conversionRatio = product.conversionRatio,
                name = product.paymentProductName,
                price = product.price,
                activityPrice = product.activityPrice,
                activitys = activity,
                eaQty = 0,
                spec = product.spec,
                unit = product.unit,
                style = product.style,
                pluLevel = product.pluLevel,
                activityType = activityType,
                productNumber = product.productNumber,
                isVirtual = product.isVirtual,
                discountTotal = product.discountTotal,
                payApportionAmount = product.payApportionAmount,
            )
            posBuyPart.toJson().dXLog()
            getPosBuyPartDao().insert(posBuyPart)
        }
        for (deleteProduct in orderResponse.deleteProducts) {
            deleteProduct.deleted = true
            deleteProduct.orderId = orderResponse.id
            deleteProduct.toString().dXLog()
            getPosBuyPartDao().insert(deleteProduct)
        }


    }


    fun query(): PosBuy? {
        return getPosBuyDao().queryPosBuy()
    }

    fun queryPosBuyPartByOrderNo(orderNo: String): List<PosBuyPart>? {
        return getPosBuyPartDao().queryByOrderNo(orderNo, false)
    }

    fun queryPosBuyPaymentByOrderNo(orderNo: String): PosBuyPayment? {
        return getPosBuyPaymentDao().queryByOrderNo(orderNo)
    }

//    fun initData(orderNo: String, posId: String,storeId:String,) {
//        var creatorId:String =CacheUtil.getLoginResponse().loginUser.creatorId
//        var creatorName:String =CacheUtil.getLoginResponse().loginUser.creatorName
//
//    }
}