package com.ypsx.yppos.room.repository

import androidx.lifecycle.LiveData
import com.ypsx.base.base.appContext
import com.ypsx.yppos.http.data.bean.PosConfigResponse
import com.ypsx.yppos.http.data.bean.PosMachineResponse
import com.ypsx.yppos.room.dao.PosConfigDao
import com.ypsx.yppos.room.database.PosDatabase
import com.ypsx.yppos.room.entity.PosConfig

class PosConfigRepository private constructor() {


    companion object {
        private val instance: PosConfigRepository = PosConfigRepository()

        fun getInstance(): PosConfigRepository {
            return instance
        }


    }

    private fun getPosConfigDao(): PosConfigDao {
        return PosDatabase.getDatabase(appContext).posConfigDao()
    }

    fun loadConfig(): PosConfig? {
        return getPosConfigDao().loadConfig()
    }


    fun savePosDetail(posMachine: PosMachineResponse) {
        val id = posMachine.id
        var posConfig = getPosConfigDao().loadConfig(id)
        if (posConfig == null) {
            posConfig = PosConfig(
                id,
                posId = posMachine.posId,
                brand = posMachine.brand,
                createTime = posMachine.createTime,
                port = posMachine.port,
                code = posMachine.code,
                creatorId = posMachine.updatorId,
                creatorName = posMachine.updatorName,
                installDiskCapacity = posMachine.installDiskCapacity,
                installationDirectory = posMachine.installationDirectory,
                ip = posMachine.ip,
                macAddress = posMachine.macAddress,
                orgId = posMachine.orgId,
                remark = posMachine.remark,
                storeId = posMachine.storeId,
                storeName = posMachine.storeName,
                status = posMachine.status,
                version = posMachine.version,
                specification = posMachine.specification
            )
            getPosConfigDao().insert(posConfig)
        } else {
            posConfig.status = posMachine.status
            posConfig.posId = posMachine.posId
            posConfig.code = posMachine.code
            posConfig.brand = posMachine.brand
            posConfig.createTime = posMachine.createTime
            posConfig.port = posMachine.port
            posConfig.creatorId = posMachine.updatorId
            posConfig.creatorName = posMachine.updatorName
            posConfig.installDiskCapacity = posMachine.installDiskCapacity
            posConfig.installationDirectory = posMachine.installationDirectory
            posConfig.ip = posMachine.ip
            posConfig.macAddress = posMachine.macAddress
            posConfig.orgId = posMachine.orgId
            posConfig.remark = posMachine.remark
            posConfig.storeId = posMachine.storeId
            posConfig.storeName = posMachine.storeName
            posConfig.version = posMachine.version
            posConfig.specification = posMachine.specification
            getPosConfigDao().update(posConfig)


        }

    }

    fun savePosConfig(id: String, config: PosConfigResponse) {
        var posConfig = getPosConfigDao().loadConfig(id)
        posConfig!!.ticketBottom = config.ticketBottom
        //是否打印电子发票
        posConfig.printTicketQrcode = config.printTicketQrcode
        //是否打印小票条码
        posConfig.printTicketBar = config.printTicketBar
        //付款方式,多个值以英文逗号分隔
        posConfig.payMethods = config.payMethods
        //删除挂单 0:全部允许 1:需店长授权
        posConfig.deleteList = config.deleteList
        //整单取消授权方式: 0: 全部允许， 1：需店长授权
        posConfig.cancelWholeOrder = config.cancelWholeOrder
        //现金圆整方式: 0: 四舍五入
        posConfig.cashRoundMode = config.cashRoundMode
        //锁屏时间，单位分钟, =0表示不锁屏，大于0表示锁屏时间(限制5-60)
        posConfig.lockScreen = config.lockScreen
        //最大挂单数: 限制0-5
        posConfig.maxPendingOrder = config.maxPendingOrder
        posConfig.storeManagerRoleName = config.options["storeManagerRoleName"]
        posConfig.einvoiceQrcodeUrlPrefix = config.options["einvoiceQrcodeUrlPrefix"]
        posConfig.storeClerkRoleName = config.options["storeClerkRoleName"]
        getPosConfigDao().update(posConfig)
    }


}