package com.ypsx.yppos.ui.adapter

import android.graphics.Color
import android.text.SpannableStringBuilder
import android.text.Spanned
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.ypsx.yppos.R
import com.ypsx.yppos.http.data.bean.InsertOrderProductDTO
import com.ypsx.yppos.http.data.entity.PosProductStyle
import com.ypsx.yppos.utils.RoundBackgroundColorSpan


class OrderProductAdapter(data: ArrayList<InsertOrderProductDTO>) :
    BaseQuickAdapter<InsertOrderProductDTO, BaseViewHolder>(
        R.layout.item_pos_product, data
    ) {
    override fun convert(holder: BaseViewHolder, item: InsertOrderProductDTO) {
        item.run {
            holder.setText(R.id.tv_barCode, "条码：$barCode")
            if (discountTotal > 0.0 || isPromotion) {
                val ssb = SpannableStringBuilder("促销 $name")
                var roundBackgroundColorSpan =
                    RoundBackgroundColorSpan(
                        14, 8, 2,
                        Color.WHITE,
                        Color.parseColor("#FF4400")
                    )
                ssb.setSpan(roundBackgroundColorSpan, 0, 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
                holder.setText(R.id.tv_name, ssb)
            } else {
                holder.setText(R.id.tv_name, name)
            }
            holder.setText(R.id.tv_price, "¥$price/$unit")
            holder.setText(R.id.tv_amount, "$amount")
            when (style) {
                PosProductStyle.SINGLE.name -> {
                    holder.setGone(R.id.ll_count, false)
                    holder.setGone(R.id.tv_weight, true)
                    holder.setText(R.id.tv_count, "${quantity.toInt()}")
                }
                PosProductStyle.WEIGHT.name -> {
                    holder.setGone(R.id.ll_count, true)
                    holder.setGone(R.id.tv_weight, false)
                    holder.setText(R.id.tv_weight, "$quantity$unit")
                }
                else -> {

                }
            }
        }
    }

}