package com.ypsx.yppos.ui.dialog

import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.Window
import android.view.WindowManager
import androidx.appcompat.app.AppCompatDialog
import androidx.databinding.DataBindingUtil
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.DialogMessageBinding
import com.ypsx.yppos.viewmodel.state.MessageViewModel

class MessageDialog(context: Context?) : AppCompatDialog(context) {
    init {
        supportRequestWindowFeature(Window.FEATURE_NO_TITLE)
    }

    private var viewDataBinding: DialogMessageBinding? = null
    var listener: OnClickSureListener? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        viewDataBinding =
            DataBindingUtil.inflate(layoutInflater, R.layout.dialog_message, null, false)
        viewDataBinding?.apply {
            vm = MessageViewModel()
            click = ProxyClick()
        }
        setContentView(viewDataBinding!!.root)
        window!!.attributes.width = WindowManager.LayoutParams.MATCH_PARENT
        window!!.attributes.height = WindowManager.LayoutParams.WRAP_CONTENT
        window!!.setGravity(Gravity.CENTER)
        setCancelable(true)
        setCanceledOnTouchOutside(false)


    }

    fun showData(title: String, content: String, cancel: String?, sure: String?, gone: Boolean = true) {
        if (!isShowing) {
            show()
        }
        viewDataBinding?.apply {
            vm!!.title.set(title)
            vm!!.content.set(content)
            vm!!.gone.set(gone)
            if (cancel != null) {
                vm!!.cancel.set(cancel)
            }
            if (sure != null) {
                vm!!.sure.set(sure)
            }

        }
    }

    fun setOnClickSureListener(listener: OnClickSureListener) {
        this.listener = listener

    }

    inner class ProxyClick {
        fun cancel() {
            dismiss()
            listener?.cancel()
        }

        fun sure() {
            dismiss()
            listener?.sure()
        }
    }


}

interface OnClickSureListener {
    fun sure()
    fun cancel()

}