package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.king.app.updater.AppUpdater
import com.king.app.updater.UpdateConfig
import com.king.app.updater.callback.UpdateCallback
import com.king.app.updater.http.OkHttpManager
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.utils.toast
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupAppUpdaterBinding
import com.ypsx.yppos.http.data.bean.AppVersionResponse
import com.ypsx.yppos.utils.dXLog
import com.ypsx.yppos.viewmodel.state.AppUpdaterViewModel
import razerdp.basepopup.BasePopupWindow
import java.io.File
import kotlin.math.roundToInt

class AppUpdaterPopupWindow(context: Context?) : BasePopupWindow(context) {
    var bind: PopupAppUpdaterBinding? = null
    lateinit var appVersionName:String
    lateinit var downloadUrl:String
     var versionCode: Int = 0
    var mAppUpdater: AppUpdater? = null



    init {
        setContentView(R.layout.popup_app_updater)
        width = appContext.screenWidth / 4 * 3
        setPopupGravity(GravityMode.RELATIVE_TO_ANCHOR, Gravity.CENTER)
        isOutSideTouchable = false
        setOutSideDismiss(false)
    }

    override fun onViewCreated(contentView: View) {
        bind = PopupAppUpdaterBinding.bind(contentView)
        bind?.vm = AppUpdaterViewModel()
        bind?.click = ProxyClick()
    }

    fun setData(appVersion: AppVersionResponse) {
        downloadUrl = appVersion.downloadUrl
        appVersionName = appVersion.versionName
        versionCode = appVersion.versionCode
        bind?.vm?.appVersion?.set("V${appVersion.versionName}")

        when (appVersion.mode) {
            "RECOMMEND","SILENT" -> {//推荐升级和静默升级
                bind?.vm?.appCancel?.set(true)
            }
            "FORCE" -> {//强制升级
                bind?.vm?.appCancel?.set(false)
            }
        }

    }

    override fun onBackPressed(): Boolean {
        return false
    }



    inner class ProxyClick {
        fun close() {
            dismiss()
            if (mAppUpdater != null) {
                mAppUpdater = null
            }
        }

        fun updater() {
            bind?.vm?.updaterShow?.set(false)

            val config = UpdateConfig()
            config.url = downloadUrl
            config.channelId = "100"
            config.channelName = "更新下载"
            config.versionCode =versionCode
            config.notificationIcon = R.mipmap.icon_yp_logo
            mAppUpdater = AppUpdater(context, config)
                .setHttpManager(OkHttpManager.getInstance())
                .setUpdateCallback(object : UpdateCallback {
                    override fun onDownloading(isDownloading: Boolean) {
                        if (isDownloading) {
                            ("已经在下载中,请勿重复下载。").toast()
                        }
                    }

                    override fun onStart(url: String) {
                        bind?.vm?.progressBarShow?.set(true)

                        bind?.progressBar?.progress = 0
                    }

                    override fun onProgress(progress: Long, total: Long, isChange: Boolean) {
                        if (isChange) {
                            val currProgress = (progress * 1.0f / total * 100.0f).roundToInt()
                            bind?.progressBar?.progress = currProgress
                        }
                    }

                    override fun onFinish(file: File) {
                        dismiss()
                        "APP下载地址：${file.absolutePath}".dXLog()
                    }

                    override fun onError(e: Exception) {
                    }

                    override fun onCancel() {
                    }
                })
            mAppUpdater?.start()
        }

    }


}