package com.ypsx.yppos.viewmodel.state

import android.os.Build.BRAND
import android.os.Build.MODEL
import com.ypsx.base.base.appContext
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.base.network.NetworkUtil
import com.ypsx.base.util.AppUtils

class RegisterViewModel : BaseViewModel() {
    val model = MODEL
    val brand = BRAND
    val ipAddress = NetworkUtil.getIPAddress(appContext)
    var port = StringObservableField("80")

    val version = "版本号：V${AppUtils.getAppVersionName()}"

    val snNo = "SN号：${AppUtils.getSnCode()}"

    var submitState = BooleanObservableField(true)

    var submitText = StringObservableField("提交申请")



}